/****** Object:  StoredProcedure [dbo].[P_SERVICE_FARMA_TOP_VENDAS]    Script Date: 02/11/2014 18:34:05 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_SERVICE_FARMA_TOP_VENDAS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_SERVICE_FARMA_TOP_VENDAS]
GO
--EXECUTE P_SERVICE_FARMA_TOP_VENDAS
--SELECT * FROM SERVICE_FARMA_TOP_VENDAS WHERE COD_PROD = 16082
CREATE PROCEDURE [dbo].[P_SERVICE_FARMA_TOP_VENDAS] AS
SET NOCOUNT ON  
SET DEADLOCK_PRIORITY HIGH;
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('SERVICE_FARMA_TOP_VENDAS') AND type in (N'U'))
DROP TABLE SERVICE_FARMA_TOP_VENDAS;
 
CREATE TABLE #EST_DEP (CD_EMP INT, CD_PROD INT, QT_EST MONEY,VLR_TABELA MONEY, VLR_CUSTO_MD MONEY,DS_SIGLA VARCHAR(2))
CREATE TABLE #VD_CUSTO_MD (CD_EMP INT, CD_PROD INT,  VLR_VD MONEY, VLR_CUSTO_MD MONEY)
CREATE TABLE #STS_LJS (CD_EMP INT, CD_PROD INT, TOT_LJ_ATIVO MONEY,TOT_LJ_INATIVO MONEY, TOT_LJ_ZERADOS MONEY ) 
CREATE TABLE #ZERADOS_FILIAL (CD_EMP INT, CD_PROD INT, QT_EST_FIL MONEY, VLR_EST_FIL MONEY, TOT_LJ_ZERADOS MONEY, QTDE_MEDIAF MONEY ,QTDE_MEDIAF_ZERO MONEY ,VLR_MEDIAF_ZERO MONEY  )
CREATE TABLE #RDESC (CD_EMP INT, CD_FILIAL INT, CD_PROD INT, PERC_DESC MONEY)

print 'Estoque e curva deposito - Time : ' +convert(varchar,getdate(),108) 
INSERT INTO #EST_DEP
SELECT   		
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_PROD,
	EST_PROD_CPL.QT_EST,
	EST_PROD_PRECO.VLR_TABELA AS VLR,
    EST_PROD_CPL.VLR_CUSTO_MD,
    EST_PROD_CURVA_SIGLA.DS_SIGLA
FROM 
	EST_PROD_CPL 
	INNER JOIN  PRC_FILIAL FIL ON 
    EST_PROD_CPL.CD_EMP    = FIL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = FIL.CD_FILIAL
	INNER JOIN EST_PROD_PRECO ON 
	EST_PROD_PRECO.CD_EMP    = EST_PROD_CPL.CD_EMP	AND 
	EST_PROD_PRECO.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
	EST_PROD_PRECO.CD_PROD   = EST_PROD_CPL.CD_PROD	
    INNER JOIN EST_PROD_CURVA_SIGLA ON 
    EST_PROD_CURVA_SIGLA.CD_EMP = EST_PROD_CPL.CD_EMP AND
    EST_PROD_CURVA_SIGLA.CD_SIGLA = EST_PROD_CPL.CD_SIGLA
 
WHERE  
	EST_PROD_CPL.CD_EMP =1 
	AND FIL.FILIAL_MTZ=1;

CREATE CLUSTERED INDEX IX_RsDepEstoque ON #EST_DEP (CD_PROD,CD_EMP); 

print 'Venda total - Time : ' +convert(varchar,getdate(),108) 	 
INSERT INTO #VD_CUSTO_MD
SELECT	 
	CD_EMP,
	CD_PROD,
	SUM(TOT_IT) AS VLR_VD,
	SUM(VLR_CUSTO_MEDIO_TOT) AS VLR_CUSTO_MEDIO
FROM
	V_PDV_VD_IT_TOT_IT
WHERE
	CD_EMP=1
	AND DT_VD = CONVERT(CHAR(10),GETDATE()- 1,112)
GROUP BY 
	CD_EMP,
	CD_PROD;

CREATE CLUSTERED INDEX IX_RsCustoVendaTop ON #VD_CUSTO_MD (CD_PROD,CD_EMP); 
	
print 'Produtos inativos - Time : ' +convert(varchar,getdate(),108) 	
INSERT INTO #STS_LJS
SELECT  
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_PROD, 
	SUM(CASE WHEN EST_PROD_CPL.STS_PROD=0 THEN 1 ELSE 0 END) AS TOT_LJ_ATIVO,
	SUM(CASE WHEN EST_PROD_CPL.STS_PROD=1 THEN 1 ELSE 0 END) AS TOT_LJ_INATIVO,
	SUM(CASE WHEN EST_PROD_CPL.QT_EST<=0 THEN 1 ELSE 0 END)   AS TOT_LJ_ZERADOS
FROM 
	EST_PROD_CPL 
	INNER JOIN PRC_FILIAL ON
	EST_PROD_CPL.CD_EMP = PRC_FILIAL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
WHERE 
	EST_PROD_CPL.CD_EMP =1
	AND PRC_FILIAL.FILIAL_MTZ <> 1   
GROUP BY 
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_PROD; 
CREATE CLUSTERED INDEX IX_RsStsLojas ON #STS_LJS (CD_PROD,CD_EMP); 
	
print 'Estoque zerados - Time : ' +convert(varchar,getdate(),108) 	
INSERT INTO #ZERADOS_FILIAL	
SELECT 
	EST_PROD_CPL.CD_EMP,
    EST_PROD_CPL.CD_PROD, 	
	SUM(EST_PROD_CPL.QT_EST) AS QT_EST_FIL,
	SUM(EST_PROD_CPL.QT_EST * EST_PROD_PRECO.VLR_TABELA) AS VLR_EST_FIL,
	SUM(CASE WHEN EST_PROD_CPL.QT_EST<=0 THEN 1 ELSE 0 END) AS TOT_LJ_ZERADOS,
	SUM(EST_PROD_CPL_MEDIAF.QTDE_MEDIAF) AS QTDE_MEDIAF,				
	SUM(CASE WHEN EST_PROD_CPL.QT_EST<=0 THEN EST_PROD_CPL_MEDIAF.QTDE_MEDIAF ELSE 0 END) AS QTDE_MEDIAF_ZERO,				
	SUM(CASE WHEN EST_PROD_CPL.QT_EST<=0 THEN 
             (EST_PROD_CPL_MEDIAF.QTDE_MEDIAF * EST_PROD_PRECO.VLR_TABELA)
        ELSE 
			0 
		END) AS VLR_MEDIAF_ZERO 
FROM 
    EST_PROD_CPL 
    INNER JOIN PRC_FILIAL ON
	EST_PROD_CPL.CD_EMP = PRC_FILIAL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
	
	INNER JOIN EST_PROD_CPL_MEDIAF ON 
	EST_PROD_CPL_MEDIAF.CD_EMP = EST_PROD_CPL.CD_EMP 	AND 
	EST_PROD_CPL_MEDIAF.CD_FILIAL = EST_PROD_CPL.CD_FILIAL 	AND 
	EST_PROD_CPL_MEDIAF.CD_PROD = EST_PROD_CPL.CD_PROD
	
	INNER JOIN EST_PROD_PRECO ON 
	EST_PROD_PRECO.CD_EMP	 = EST_PROD_CPL.CD_EMP AND
    EST_PROD_PRECO.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
	EST_PROD_PRECO.CD_PROD   = EST_PROD_CPL.CD_PROD
WHERE 
	EST_PROD_CPL.CD_EMP=1
	AND PRC_FILIAL.FILIAL_MTZ <> 1 		        
GROUP BY 
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_PROD;
CREATE CLUSTERED INDEX IX_RsZeradosFiliais ON #ZERADOS_FILIAL (CD_PROD,CD_EMP); 
	 
print 'Desconto programado - Time : ' +convert(varchar,getdate(),108) 	
INSERT INTO #RDESC
SELECT 
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_EMP,
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD, 
	AVG(EST_PROD_PRECO_DESC_PRG_CPL.PERC_DESC) AS  PERC_DESC 
FROM         
	EST_PROD_PRECO_DESC_PRG 
	INNER JOIN EST_PROD_PRECO_DESC_PRG_CPL ON 
	EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_CPL.CD_PRECO_PRG 
	INNER JOIN EST_PROD_PRECO_DESC_PRG_PRC_FILIAL ON 
	EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_PRECO_PRG
WHERE   
	EST_PROD_PRECO_DESC_PRG.DT_INI <= CONVERT(CHAR(10),GETDATE(),112) 
	AND EST_PROD_PRECO_DESC_PRG.DT_VENCTO >= CONVERT(CHAR(10),GETDATE(),112)
GROUP BY 
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_EMP,
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD;;
CREATE CLUSTERED INDEX IX_RsDescontos ON #RDESC (CD_PROD,CD_EMP); 
	
print 'Finalizacao top vendas - Time : ' +convert(varchar,getdate(),108) 	
SELECT 	
	EST_PROD.CD_PROD AS COD_PROD,
	EST_PROD.DS_PROD AS DESCRICAO,
	SUM(EST_PROD_CPL_MEDIAF.QTDE_FACEAMENTO) as FACE,
	EST_DEP.DS_SIGLA AS CURVA,
	SUM((ZERADOS_FIL.QTDE_MEDIAF / 30) * EST_PROD_CPL.EMAX) AS EMAX,
	ZERADOS_FIL.QTDE_MEDIAF AS MEDIAF,
	ZERADOS_FIL.QTDE_MEDIAF * EST_DEP.VLR_TABELA  as MEDIAF_VAL,
	EST_PROD_FABRIC.NM_FABRIC AS FABRICANTE,
	SUM(EST_PROD_CPL.QT_VD_MES3) AS VENDA_QT_MES_30D,
	SUM(EST_PROD_CPL.QT_VD_MES3 * EST_DEP.VLR_TABELA) AS VENDA_FIN_MES_30D,
	SUM(EST_PROD_CPL.QT_VD_MES1) AS VENDA_QT_MES_1,
	SUM(EST_PROD_CPL.QT_VD_MES2) AS VENDA_QT_MES_2,
	SUM(EST_PROD_CPL.QT_VD_MES3) AS VENDA_QT_MES_3,
	0 AS FIN,
	SUM((ZERADOS_FIL.QTDE_MEDIAF / 30) * EST_PROD_CPL.ESEG) AS ESEG,
	EST_DEP.QT_EST AS ESTOQUE_SEDE,
	EST_DEP.VLR_TABELA * EST_DEP.QT_EST AS ESTOQUE_SEDE_VAL,
	DS_ARV_MERC_LINHA AS GRUPO,
	CASE WHEN EST_PROD.COMPRA_POR_SUPRIMENTO = 0 THEN 
				'RESSUPRIMENTO'
			WHEN EST_PROD.COMPRA_POR_SUPRIMENTO = 1 THEN 
				'SUPRIMENTO'
			WHEN EST_PROD.COMPRA_POR_SUPRIMENTO = 2 THEN 
				 'SUP-RESSUP' 
			END AS TIPO, 
    NULL AS EXCLUSIVIDADE,
	EST_DEP.VLR_TABELA AS PRECO_VENDA,
	EST_DEP.VLR_CUSTO_MD AS CUSTO_MEDIO,
    ((vm.VLR_VD - vm.VLR_CUSTO_MD) / vm.VLR_VD) * 100 AS MARGEM_BRUTA,
	STATUS_FIL.TOT_LJ_ATIVO AS FIL_ATIVO,
	STATUS_FIL.TOT_LJ_INATIVO AS FIL_INATIVO,
	ZERADOS_FIL.TOT_LJ_ZERADOS AS ZERADOS,
    ZERADOS_FIL.QTDE_MEDIAF_ZERO AS MEDIAF_EST_ZERO,
	(ZERADOS_FIL.QTDE_MEDIAF_ZERO * EST_DEP.VLR_TABELA) AS MEDIAF_VAL_EST_ZERO,
	ZERADOS_FIL.QT_EST_FIL AS ESTOQUE_FILIAL,
	ZERADOS_FIL.VLR_EST_FIL AS ESTOQUE_FILIAL_VAL,
	SUM(V_EST_PROD_CPL_PENDENCIAS.QT_PEND_SAI) AS PEDIDO_PENDENTE_LJ,
	SUM(V_EST_PROD_CPL_PENDENCIAS.QT_PEND_ENT) AS PEDIDO_PENDENTE_CD,    
	AVG(CASE WHEN ISNULL(EST_PROD.PERC_DESC,0) = 0 THEN
		rdesc.PERC_DESC 
	ELSE
		ISNULL(EST_PROD.PERC_DESC,0)
	END) AS DESCONTO_VENDA	
	INTO SERVICE_FARMA_TOP_VENDAS
FROM
	EST_PROD 
	INNER JOIN EST_PROD_CPL ON 
	EST_PROD.CD_EMP  = EST_PROD_CPL.CD_EMP AND 
	EST_PROD.CD_PROD = EST_PROD_CPL.CD_PROD	
	INNER JOIN EST_PROD_PRECO TBL ON
	EST_PROD_CPL.CD_EMP = TBL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = TBL.CD_FILIAL AND
	EST_PROD_CPL.CD_PROD = TBL.CD_PROD 
	INNER JOIN EST_MC ON EST_PROD.CD_EMP = EST_MC.CD_EMP AND
	EST_PROD.CD_MC = EST_MC.CD_MC
	INNER JOIN est_prod_cpl_mediaF on 
	EST_PROD_CPL_MEDIAF.CD_EMP = EST_PROD_CPL.CD_EMP AND
	EST_PROD_CPL_MEDIAF.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND
	EST_PROD_CPL_MEDIAF.CD_PROD = EST_PROD_CPL.CD_PROD
	INNER JOIN EST_PROD_FABRIC ON  
	EST_PROD_FABRIC.CD_FABRIC = EST_PROD.CD_FABRIC
	INNER JOIN #EST_DEP  EST_DEP ON
	EST_DEP.CD_PROD   = EST_PROD_CPL.CD_PROD

	LEFT JOIN V_EST_PROD_CPL_PENDENCIAS ON
	EST_PROD_CPL.CD_EMP =	V_EST_PROD_CPL_PENDENCIAS.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = V_EST_PROD_CPL_PENDENCIAS.CD_FILIAL AND
	EST_PROD_CPL.CD_PROD = V_EST_PROD_CPL_PENDENCIAS.CD_PROD 
	
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA ON
	EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP and
	EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
	
	INNER JOIN EST_ARV_MERC_LINHA ON 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA AND 
	EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP = EST_ARV_MERC_LINHA.CD_EMP	
	
	INNER JOIN  #VD_CUSTO_MD vm ON		
	EST_PROD.CD_EMP = vm.CD_EMP AND 
	EST_PROD.CD_PROD = vm.CD_PROD
	
	INNER JOIN #STS_LJS STATUS_FIL on 
	EST_PROD.CD_EMP = STATUS_FIL.CD_EMP AND 
    EST_PROD.CD_PROD   = STATUS_FIL.CD_PROD

	INNER JOIN  #ZERADOS_FILIAL AS ZERADOS_FIL on 
	EST_PROD.CD_EMP   = ZERADOS_FIL.CD_EMP AND
	EST_PROD.CD_PROD   = ZERADOS_FIL.CD_PROD

	LEFT OUTER JOIN  #RDESC RDESC ON 
	EST_PROD_CPL.CD_EMP = RDESC.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = RDESC.CD_FILIAL AND
	EST_PROD_CPL.CD_PROD  = RDESC.CD_PROD					

GROUP BY 
	EST_PROD.CD_PROD,
	EST_PROD.DS_PROD,
	EST_PROD_FABRIC.NM_FABRIC,
	EST_DEP.QT_EST,
	EST_ARV_MERC_LINHA.DS_ARV_MERC_LINHA, 
	EST_PROD.COMPRA_POR_SUPRIMENTO,
	EST_DEP.VLR_TABELA,
	EST_DEP.VLR_CUSTO_MD,
	STATUS_FIL.TOT_LJ_ATIVO,
	STATUS_FIL.TOT_LJ_INATIVO, 
	ZERADOS_FIL.TOT_LJ_ZERADOS, 
	ZERADOS_FIL.QTDE_MEDIAF_ZERO,
	ZERADOS_FIL.VLR_MEDIAF_ZERO, 
	ZERADOS_FIL.QT_EST_FIL, 
	ZERADOS_FIL.VLR_EST_FIL, 
	EST_DEP.DS_SIGLA,
	EST_PROD.PERC_DESC,
	ZERADOS_FIL.QTDE_MEDIAF,
	vm.VLR_VD,
	vm.VLR_CUSTO_MD;

DROP TABLE #EST_DEP; 
DROP TABLE #VD_CUSTO_MD; 
DROP TABLE #STS_LJS ;
DROP TABLE #ZERADOS_FILIAL; 
DROP TABLE #RDESC ;
